/*  MessageTooLargeException.java
 *  Copyright (C) 2001 by Christopher R. Jones. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.mischiefbox.pollserve;

/**
 *  Indicates that a message was too large.
 *
 *  The connection handler should consider dumping the connection
 *  because this may be a deliberate attempt to deny service.
 *
 *  @author Chris Jones
 *  @version $Id$
 */
public class MessageTooLargeException extends Exception {
    /**
     *  The offending connection id.
     */
    protected String sConnectionId;

    /**
     *  Create a new message too-large exception.
     *
     *  @param sConnectionId the connection id that sent the
     *         too-large message.
     */
    public MessageTooLargeException(String sConnectionId) {
        super("Incoming message was too large from connection " +
          sConnectionId + ".");
        this.sConnectionId = sConnectionId;
    }
        
    /**
     *  Gets the offending connection id.
     *
     *  @return the connection id that sent the too-large message.
     */
    public String getConnectionId() {
         return sConnectionId;
    }
}

/*
 * $Log$
 */
